/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.templates;

import com.google.common.math.StatsAccumulator;
import com.mojang.serialization.Codec;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2776;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3614;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5821;

public abstract class TemplateFeature<T extends class_3037>
extends class_3031<T> {
    public TemplateFeature(Codec<T> config) {
        super(config);
    }

    public final boolean method_13151(class_5821<T> ctx) {
        int dz;
        class_5281 world = ctx.method_33652();
        class_2338 pos = ctx.method_33655();
        Random random = world.method_8409();
        class_3485 templateManager = world.method_8410().method_8503().method_27727();
        class_3499 template = this.getTemplate(templateManager, random);
        if (template == null) {
            return false;
        }
        class_2470 rotation = class_2470.method_16548((Random)random);
        class_2415 mirror = (class_2415)class_156.method_27173((Object[])class_2415.values(), (Random)random);
        class_1923 chunkpos = new class_1923(pos);
        class_3341 structureMask = new class_3341(chunkpos.method_8326(), world.method_31607(), chunkpos.method_8328(), chunkpos.method_8327(), world.method_31600(), chunkpos.method_8329());
        class_2338 posSnap = chunkpos.method_8323().method_10069(0, pos.method_10264(), 0);
        class_2382 transformedSize = template.method_15166(rotation);
        int dx = random.nextInt(16 - transformedSize.method_10263());
        class_2338.class_2339 startPos = new class_2338.class_2339((posSnap = posSnap.method_10069(dx, 0, dz = random.nextInt(16 - transformedSize.method_10260()))).method_10263(), posSnap.method_10264(), posSnap.method_10260());
        if (!TemplateFeature.offsetToAverageGroundLevel(world, startPos, transformedSize)) {
            return false;
        }
        startPos.method_10100(0, this.yLevelOffset(), 0);
        class_2338 placementPos = template.method_15167((class_2338)startPos, mirror, rotation);
        class_3492 placementSettings = new class_3492().method_15125(mirror).method_15123(rotation).method_15126(structureMask).method_15112(random);
        this.modifySettings(placementSettings.method_16183(), random);
        template.method_15172((class_5425)world, placementPos, placementPos, placementSettings, random, 20);
        for (class_3499.class_3501 info : template.method_16445(placementPos, placementSettings, class_2246.field_10465)) {
            if (info.field_15595 == null || class_2776.valueOf((String)info.field_15595.method_10558("mode")) != class_2776.field_12696) continue;
            this.processMarkers(info, world, rotation, mirror, random);
        }
        this.postPlacement(world, random, templateManager, rotation, mirror, placementSettings, placementPos);
        return true;
    }

    @Nullable
    protected abstract class_3499 getTemplate(class_3485 var1, Random var2);

    protected void modifySettings(class_3492 settings, Random random) {
    }

    protected void processMarkers(class_3499.class_3501 info, class_5281 world, class_2470 rotation, class_2415 mirror, Random random) {
    }

    protected void postPlacement(class_5281 world, Random random, class_3485 templateManager, class_2470 rotation, class_2415 mirror, class_3492 placementSettings, class_2338 placementPos) {
    }

    protected int yLevelOffset() {
        return 0;
    }

    private static boolean offsetToAverageGroundLevel(class_5281 world, class_2338.class_2339 startPos, class_2382 size) {
        StatsAccumulator heights = new StatsAccumulator();
        for (int dx = 0; dx < size.method_10263(); ++dx) {
            for (int dz = 0; dz < size.method_10260(); ++dz) {
                int y;
                int x = startPos.method_10263() + dx;
                int z = startPos.method_10260() + dz;
                for (y = world.method_8624(class_2902.class_2903.field_13203, x, z); y >= 0; --y) {
                    class_2680 state = world.method_8320(new class_2338(x, y, z));
                    if (TemplateFeature.isBlockNotOk(state)) {
                        return false;
                    }
                    if (TemplateFeature.isBlockOk(state)) break;
                }
                if (y < 0) {
                    return false;
                }
                heights.add((double)y);
            }
        }
        if (heights.populationStandardDeviation() > 2.0) {
            return false;
        }
        int baseY = (int)(heights.mean() + 0.5);
        int maxY = (int)heights.max();
        startPos.method_33098(baseY);
        return TemplateFeature.isAreaClear((class_1936)world, startPos.method_10086(maxY - baseY + 1), startPos.method_10081(size));
    }

    private static boolean isAreaClear(class_1936 world, class_2338 min, class_2338 max) {
        for (class_2338 pos : class_2338.method_10097((class_2338)min, (class_2338)max)) {
            if (world.method_8320(pos).method_26207().method_15800()) continue;
            return false;
        }
        return true;
    }

    private static boolean isBlockOk(class_2680 state) {
        class_3614 material = state.method_26207();
        return material == class_3614.field_15914 || material == class_3614.field_15941 || material == class_3614.field_15945 || material == class_3614.field_15916;
    }

    private static boolean isBlockNotOk(class_2680 state) {
        class_3614 material = state.method_26207();
        return material == class_3614.field_15920 || material == class_3614.field_15922 || state.method_26204() == class_2246.field_9987;
    }

    private static boolean isDataBlock(class_3499.class_3501 info) {
        return class_2776.field_12696.name().equals(info.field_15595.method_10558("mode"));
    }
}

